function plotIndiv(resultado, varargin)
% Plotar scores individuais similar ao plotIndiv do R
    
    p = inputParser;
    addParameter(p, 'indNames', false, @(x) islogical(x) || iscell(x));
    addParameter(p, 'legend', true, @islogical);
    addParameter(p, 'comp', [1, 2], @isnumeric);
    
    parse(p, varargin{:});
    
    comp = p.Results.comp;
    
    figure;
    hold on;
    
    % Plotar scores
    scatter(resultado.T(:, comp(1)), resultado.T(:, comp(2)), 50, 'filled');
    
    xlabel(sprintf('Componente %d (%.1f%%)', comp(1), resultado.X_var(comp(1))));
    ylabel(sprintf('Componente %d (%.1f%%)', comp(2), resultado.X_var(comp(2))));
    title('PLS-DA - Plot de Scores');
    grid on;
    
    if p.Results.legend
        legend('Location', 'best');
    end
end